/***************************************************************************

msf2blc:  A program to convert a GCG .MSF file into an AMPS blockfile.

   Copyright:  University of Oxford (1992)

TERMS OF USE:

The computer software and associated documentation called ALSCRIPT hereinafter
referred to as the WORK is more particularly identified and described in 
Appendix A.

The WORK was written and developed by: Geoffrey J. Barton

Laboratory of Molecular Biophysics
University of Oxford
Rex Richards Building
South Parks Road
Oxford OX1 3QU
U.K.

Tel:  (+44) 865-275368
Fax:  (+44) 865-510454

Internet: gjb@bioch.ox.ac.uk
Janet:    gjb@uk.ac.ox.bioch

The WORK is Copyright (1992) University of Oxford

Administrative Offices
Wellington Square
Oxford OX1 2JD
U.K.

CONDITIONS:

The WORK is made available for educational and non-commercial research 
purposes.

For commercial use, a commercial licence is required - contact the author
at the above address for details.

The WORK may be copied and redistributed, provided that no charge is
made for the WORK, that the WORK is not incorporated into a program or
package for sale and that this text, all copyright notices and the
authors' address is left unchanged on every copy.

The WORK may be modified, however this text, all copyright notices and
the authors' address must be left unchanged on every copy, and all
changes must be documented after this notice.  A copy of the
modified WORK must be supplied to the author.

All use of the WORK must cite:  Barton, G. J. (1993), ALSCRIPT: A Tool to
Format Multiple Sequence Alignments, Protein Engineering, Volume 6, No. 1, 
pp. 37-40.

APPENDIX A:

The program package known as ALSCRIPT is made up of the following files:

README     	This copyright notice
EXAMPLE.BLC     Example block file
EXAMPLE.COM     Example command file
EXAMPLE1.BLC    Example block file
EXAMPLE1.COM    Example command file
EXAMPLE2.COM    Example command file
EXAMPLE3.COM    Example command file
ALSCRIPT.EXE    ALSCRIPT executable program
MSF2BLC.EXE     GCG MSF to BLOCK file conversion program
CLUS2BLC.EXE    CLUSTAL PIR file to BLOCK file conversion program
EXAMPLE1.PS     Example output of program
ALSCRIPT.DOC    Documentation
MAKEFILE        Makefile for programs
MAKEFILE.GCC    Makefile for GCC compiler
MAKEFILE.SGI    Makefile for Silicon Graphics 
MAKEFILE.WAT    Makefile for WATCOM 386 C compiler
AGETBLOC.C      Source code for block file reading routine
ALPS.C          Source code for main ALSCRIPT routines
ARRAY.H         Header file
CLUS2BLC.C      Source code for CLUSTAL PIR file to BLOCK file conversion program
DEFAULTS.H      Header file
GJUTIL.C        Source code for utility routines
GJUTIL.H        pHeader file for utility routines
MSF2BLC.C       Source code for GCG MSF to BLOCK file conversion program
MAKEFILE.SUN    Makefile for Sun acc compiler.
ALSCRIPT.C      Source code for ALSCRIPT main program

****************************************************************************

Notes:  This program can be run as a pipe:  type msf2blc -q < input > output
Only error messages will be output to std_err

Default mode is interactive and prompts for filenames.

The storage for the sequences is allocated dynamically, so the MAX_SEQ_LEN
defines in the header file "defaults.h" have no effect.  If a system memory
limit is reached, then a "malloc error" message will be written and the
program will stop.  Most computers should happily cope with large numbers of
long sequences.  Some possible solutions to this problem are outlined in
the user manual - alscript.doc
****************************************************************************/

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "gjutil.h"
#include "array.h"
#include "defaults.h"

#define TOKENS " \t\n"


main(int argc,char *argv[])
{
	struct seqdat *seqs;
	FILE *fp,*fout;
	int nseq;
	int found;
	int i,j;
        char *token,*sbit;
        char *line;
        extern FILE *std_err,*std_in,*std_out;
        char *msffile;
        char *blocfile;
        int quiet;
        
        std_err = stderr;
        std_in = stdin;
        std_out = stdout;
        
        line = GJstrcreate(MAX_INLEN," ");
        msffile = GJstrcreate(MAX_INLEN,NULL);
        blocfile = GJstrcreate(MAX_INLEN,NULL);

        nseq = 0;
        found = 0;
        quiet = 0;

        if(argc > 1){
	  if(strcmp(argv[1],"-q")==0){
            /* Quiet mode - read .MSF file from stdin and output block file to stdout */
            quiet = 1;
            fp = std_in;
            fout = std_out;
	  }
        }else{
          /* Verbose mode - prompt for all filenames */
          fprintf(std_out,"\n\n");
          fprintf(std_out,"GCG .MSF to AMPS Blockfile conversion\n");
          fprintf(std_out,"Copyright: University of Oxford (1992)\n");
          fprintf(std_out,"Author: G. J. Barton (1992)\n\n");
          fprintf(std_out,"Max number/length of alignment - Defined by System\n");
          fprintf(std_out,"If you get a malloc error message - see manual\n\n");
          fprintf(std_out,"Enter MSF filename: ");
          
          fscanf(std_in,"%s",msffile);
          fprintf(std_out,"Opening: %s\n",msffile);
          fp = GJfopen(msffile,"r",1);
          
          fprintf(std_out,"Enter Block filename: ");
          fscanf(std_in,"%s",blocfile);
          fprintf(std_out,"Opening: %s\n",blocfile);
          fout = GJfopen(blocfile,"w",1);
        }
	
	fprintf(fout,"\n");
	fprintf(fout,"Conversion of GCG .MSF file to AMPS BLOCKFILE format\n");
	fprintf(fout,"msf2blc:  Geoffrey J. Barton (1992)\n\n");

        seqs = (struct seqdat *) GJmalloc(sizeof(struct seqdat));

       	if(!quiet)fprintf(std_out,"Reading .blc file\n");
        while(fgets(line,MAX_INLEN,fp) != NULL){
	  if(line[0] != '\n'){
             token = strtok(line,TOKENS);
             if(token != NULL){
               if(strcmp(token,"Name:") == 0){
                 /* This is a seq id name */
                  token = strtok(NULL,TOKENS);
                  seqs = (struct seqdat *) GJrealloc(seqs,sizeof(struct seqdat) * (nseq +1));
                  seqs[nseq].id = GJstrdup(token);
                  seqs[nseq].title = GJstrdup(line);
                  seqs[nseq].slen = 0;
                  seqs[nseq].seq = (char *) GJmalloc(sizeof(char));
                  ++nseq;
                  if(!quiet)fprintf(std_out,"%s\n",seqs[nseq-1].id);
	       }else if((strcmp(token,"//") == 0) || found){
                  /* this signals the end of identifiers so process sequences*/
                  found = 1;
                  if(token != NULL){
                    /* find out which seq this is */
                    i=0;
		    for(i=0;i<nseq;++i){
	               if(strcmp(token,seqs[i].id) == 0){
		         break;
		       }
		     }
                     /* read in the sequence */
                     if(i < nseq){
                       token = strtok(NULL,"\n");
                       if(token == NULL){
                         GJerror("Cannot find sequence in line");
                         fprintf(std_err,"%s",line);
                         exit(1);
		       }
                       j=0;
                       while(token[j] != '\0'){
                         if(isalpha(token[j]) || token[j] == '.'){
                           seqs[i].seq = (char *) GJrealloc(seqs[i].seq,sizeof(char) * (seqs[i].slen +1));
                           seqs[i].seq[seqs[i].slen] = token[j];
                           ++seqs[i].slen;
			 }
                         ++j;
		       }
		     }
		  }
		}else{
                  /* this is a comment line - just echo */
                  fprintf(fout,"%s\n",line);
		}
	     }
	   }
	}
        if(!quiet)fprintf(std_out,"All %d sequences read in\n",nseq);
        if(!quiet)fprintf(std_out,"Writing .blc file\n");
        
        for(i=0;i<nseq;++i){
            fprintf(fout,">%s %s\n",seqs[i].id,seqs[i].title);
        }
        fprintf(fout,"* iteration 1\n");
        for(i=0;i<seqs[0].slen;++i){
            for(j=0;j<nseq;++j){
                fprintf(fout,"%c",seqs[j].seq[i]);
            }
            fprintf(fout,"\n");
        }
        fprintf(fout,"*\n");
        if(!quiet)fprintf(std_out,"All done\n");
        
        for(i=0;i<nseq;++i){
	  GJfree(seqs[i].seq);
	  GJfree(seqs[i].id);
  	  GJfree(seqs[i].title);
	}
	GJfree(seqs);
	GJfree(line);
	GJfree(blocfile);
	GJfree(msffile);

}	
